package doABC.Multiname;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import doABC.CpoolInfo;
import FlashReader.SWF;
import FlashReader.SwfTools;

public class MultinameKindRTQName extends SwfTools{

	private CpoolInfo cpool;
	
	private int start;
	private int end;
	//struktury
	private int name=-1;
	
	
	public MultinameKindRTQName(CpoolInfo cpool, int name){
		super();
		this.cpool = cpool;
		this.name=name;
	}
	
	
	public MultinameKindRTQName(ByteBuffer bbuf,CpoolInfo cpool){
		super();
		this.cpool = cpool;
		multiname_kind_RTQName(bbuf);
	}
	
	
	private void  multiname_kind_RTQName(ByteBuffer bbuf){
		
		start = bbuf.position();
		
		name = 	unsigned30int(bbuf);

		end = bbuf.position()-1;
	
		//if (!nsS.equals(""))
		//multiname_info.add(nsS + "::" +nameS );
		//else multiname_info.add(nameS );
		
		
	}


	public int getStart() {
		return start;
	}


	public int getEnd() {
		return end;
	}



	public int getName() {
		return name;
	}


	public String getName_string() {
		return cpool.getStrings().get(name).getUtf8_string();

	}
	

	public String String(){
		String wynik ="";
		wynik+="\n---#--- option_info "+SWF.msgs.getString("Position")+": " + start + "\n\n";
			
		wynik+= "name: " + getName_string()+"\n";
			
		wynik+="\n---!!--- "+SWF.msgs.getString("Position")+":  "+end;
		
		return wynik;
		
		
	}

	
	public String toString(){
		String wynik ="";
	
		wynik += getName_string();

		return wynik;
	}
	
	public ArrayList<Byte> toByteCode(){
		ArrayList<Byte> result = new ArrayList<Byte>();

		if (  name!=-1){
			ArrayList<Byte> tmp =getUI32(name);
			for (int i=0;i<tmp.size();i++)
				result.add(tmp.get(i));
		}
		
		return result;
	}
	
	
	
}
